#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization"
show title

$Expt << END
#                                
#  Component       LMW          MW
#------------   ---------   ---------
     N2              NaN      28.014
     CO2             NaN      44.010
     C1              NaN      16.043
     C2              NaN      30.070
     C3              NaN      44.097
     i-C4            NaN      58.123
     n-C4            NaN      58.123
     i-C5            NaN      72.150
     n-C5            NaN      72.150
     C6           77.007      84.021
     C7           90.778      97.791
     C8          104.714     111.727
     C9          118.693     125.706
     C10         132.681     139.695
     C11         146.670     153.684
     C12+        160.656     170.000
END
set xlabel "Lower Molecular Weight"
set ylabel "Molecular Weight"
set output "Figures/Table_001_MW_vs_LMW_1.pdf"
plot [*:*][*:*] $Expt using 2:3 with points notitle

set title "Gamma Fit of GasInput C6+ MWs"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     76.83       84.02       83.86     5.9006e-01    5.9006e-01    5.3797e-01    5.3694e-01
     92.13       97.79       98.34     2.8096e-01    2.8096e-01    2.9814e-01    2.9983e-01
    106.75      111.73      111.89     8.9135e-02    8.9135e-02    1.0807e-01    1.0822e-01
    119.12      125.71      124.72     3.1629e-02    3.1629e-02    4.3143e-02    4.2804e-02
    133.72      139.69      139.36     6.9830e-03    6.9830e-03    1.0585e-02    1.0560e-02
    149.46      153.68      154.44     1.0269e-03    1.0269e-03    1.7125e-03    1.7210e-03
    163.18      170.00      170.39     2.0538e-04    2.0538e-04    3.7887e-04    3.7974e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_001_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_001_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_001_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_001_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Model of GasInput C6+ Moles"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     76.83       84.02       83.31     5.9006e-01    5.5034e-01    5.3797e-01    4.9753e-01
     90.78       97.79       96.80     2.8096e-01    2.9576e-01    2.9814e-01    3.1066e-01
    104.71      111.73      110.41     8.9135e-02    1.1230e-01    1.0807e-01    1.3454e-01
    118.69      125.71      124.13     3.1629e-02    3.2354e-02    4.3143e-02    4.3580e-02
    132.68      139.69      137.92     6.9830e-03    7.5013e-03    1.0585e-02    1.1226e-02
    146.67      153.68      151.75     1.0269e-03    1.4593e-03    1.7125e-03    2.4029e-03
    160.66      170.00      167.94     2.0538e-04    2.8790e-04    3.7887e-04    5.2466e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_002_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_002_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_002_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_002_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Moles"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     79.76       84.02       84.48     5.9006e-01    5.8961e-01    5.3797e-01    5.4051e-01
     90.78       97.79       96.46     2.8096e-01    2.8039e-01    2.9814e-01    2.9350e-01
    104.71      111.73      110.38     8.9135e-02    8.9781e-02    1.0807e-01    1.0754e-01
    118.69      125.71      124.35     3.1629e-02    2.7983e-02    4.3143e-02    3.7757e-02
    132.68      139.69      138.32     6.9830e-03    8.5595e-03    1.0585e-02    1.2847e-02
    146.67      153.68      152.29     1.0269e-03    2.5810e-03    1.7125e-03    4.2652e-03
    160.66      170.00      172.07     2.0538e-04    1.0904e-03    3.7887e-04    2.0360e-03
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_003_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_003_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_003_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_003_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Log Moles"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     73.45       84.02       81.66     5.9006e-01    5.9259e-01    5.3797e-01    5.2507e-01
     90.78       97.79       96.84     2.8096e-01    2.6747e-01    2.9814e-01    2.8106e-01
    104.71      111.73      110.40     8.9135e-02    1.0317e-01    1.0807e-01    1.2360e-01
    118.69      125.71      124.09     3.1629e-02    2.9043e-02    4.3143e-02    3.9105e-02
    132.68      139.69      137.85     6.9830e-03    6.3752e-03    1.0585e-02    9.5359e-03
    146.67      153.68      151.65     1.0269e-03    1.1444e-03    1.7125e-03    1.8833e-03
    160.66      170.00      167.53     2.0538e-04    2.0008e-04    3.7887e-04    3.6372e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_004_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_004_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_004_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_004_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Moles"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     80.11       84.02       84.71     5.9006e-01    5.8558e-01    5.3797e-01    5.3828e-01
     90.78       97.79       96.43     2.8096e-01    2.8612e-01    2.9814e-01    2.9938e-01
    104.71      111.73      110.37     8.9135e-02    8.9340e-02    1.0807e-01    1.0700e-01
    118.69      125.71      124.35     3.1629e-02    2.7622e-02    4.3143e-02    3.7270e-02
    132.68      139.69      138.33     6.9830e-03    8.5110e-03    1.0585e-02    1.2776e-02
    146.67      153.68      152.32     1.0269e-03    2.6189e-03    1.7125e-03    4.3287e-03
    160.66      170.00      172.51     2.0538e-04    1.1630e-03    3.7887e-04    2.1772e-03
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_005_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_005_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_005_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_005_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Log Moles"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     71.57       84.02       80.94     5.9006e-01    5.9395e-01    5.3797e-01    5.2163e-01
     90.78       97.79       96.89     2.8096e-01    2.6368e-01    2.9814e-01    2.7724e-01
    104.71      111.73      110.42     8.9135e-02    1.0508e-01    1.0807e-01    1.2590e-01
    118.69      125.71      124.07     3.1629e-02    2.9634e-02    4.3143e-02    3.9897e-02
    132.68      139.69      137.81     6.9830e-03    6.3576e-03    1.0585e-02    9.5071e-03
    146.67      153.68      151.60     1.0269e-03    1.0930e-03    1.7125e-03    1.7980e-03
    160.66      170.00      167.29     2.0538e-04    1.7803e-04    3.7887e-04    3.2318e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_006_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_006_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_006_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_006_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ MWs"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     76.79       84.02       83.86     5.9006e-01    5.9118e-01    5.3797e-01    5.3797e-01
     92.17       97.79       98.37     2.8096e-01    2.7930e-01    2.9814e-01    2.9814e-01
    106.74      111.73      111.87     8.9135e-02    8.9024e-02    1.0807e-01    1.0807e-01
    119.06      125.71      124.68     3.1629e-02    3.1890e-02    4.3143e-02    4.3143e-02
    133.72      139.69      139.37     6.9830e-03    6.9995e-03    1.0585e-02    1.0585e-02
    149.50      153.68      154.47     1.0269e-03    1.0217e-03    1.7125e-03    1.7125e-03
    163.19      170.00      170.40     2.0538e-04    2.0490e-04    3.7887e-04    3.7887e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_007_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_007_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_007_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_007_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Model of GasInput C6+ Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     76.79       84.02       83.29     5.9006e-01    5.5023e-01    5.3797e-01    4.9733e-01
     90.78       97.79       96.80     2.8096e-01    2.9543e-01    2.9814e-01    3.1031e-01
    104.71      111.73      110.41     8.9135e-02    1.1232e-01    1.0807e-01    1.3457e-01
    118.69      125.71      124.13     3.1629e-02    3.2383e-02    4.3143e-02    4.3619e-02
    132.68      139.69      137.92     6.9830e-03    7.5084e-03    1.0585e-02    1.1237e-02
    146.67      153.68      151.74     1.0269e-03    1.4601e-03    1.7125e-03    2.4042e-03
    160.66      170.00      167.94     2.0538e-04    2.8778e-04    3.7887e-04    5.2443e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_008_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_008_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_008_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_008_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     79.74       84.02       84.49     5.9006e-01    5.8613e-01    5.3797e-01    5.3738e-01
     90.78       97.79       96.48     2.8096e-01    2.8400e-01    2.9814e-01    2.9731e-01
    104.71      111.73      110.38     8.9135e-02    9.1269e-02    1.0807e-01    1.0931e-01
    118.69      125.71      124.32     3.1629e-02    2.8018e-02    4.3143e-02    3.7796e-02
    132.68      139.69      138.28     6.9830e-03    8.3162e-03    1.0585e-02    1.2478e-02
    146.67      153.68      152.24     1.0269e-03    2.4043e-03    1.7125e-03    3.9718e-03
    160.66      170.00      171.50     2.0538e-04    9.4053e-04    3.7887e-04    1.7503e-03
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_009_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_009_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_009_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_009_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     73.09       84.02       81.48     5.9006e-01    6.1032e-01    5.3797e-01    5.3960e-01
     90.78       97.79       96.84     2.8096e-01    2.7011e-01    2.9814e-01    2.8384e-01
    104.71      111.73      110.40     8.9135e-02    1.0436e-01    1.0807e-01    1.2502e-01
    118.69      125.71      124.09     3.1629e-02    2.9410e-02    4.3143e-02    3.9600e-02
    132.68      139.69      137.85     6.9830e-03    6.4613e-03    1.0585e-02    9.6647e-03
    146.67      153.68      151.65     1.0269e-03    1.1606e-03    1.7125e-03    1.9099e-03
    160.66      170.00      167.53     2.0538e-04    2.0298e-04    3.7887e-04    3.6900e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_010_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_010_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_010_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_010_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     79.86       84.02       84.55     5.9006e-01    5.8584e-01    5.3797e-01    5.3750e-01
     90.78       97.79       96.47     2.8096e-01    2.8418e-01    2.9814e-01    2.9747e-01
    104.71      111.73      110.38     8.9135e-02    9.1179e-02    1.0807e-01    1.0921e-01
    118.69      125.71      124.34     3.1629e-02    2.8347e-02    4.3143e-02    3.8247e-02
    132.68      139.69      138.31     6.9830e-03    8.6182e-03    1.0585e-02    1.2934e-02
    146.67      153.68      152.28     1.0269e-03    2.5754e-03    1.7125e-03    4.2557e-03
    160.66      170.00      171.94     2.0538e-04    1.0696e-03    3.7887e-04    1.9955e-03
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_011_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_011_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_011_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_011_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set title "Gamma Fit of GasInput C6+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
     70.82       84.02       80.60     5.9006e-01    6.1818e-01    5.3797e-01    5.4064e-01
     90.78       97.79       96.90     2.8096e-01    2.6603e-01    2.9814e-01    2.7971e-01
    104.71      111.73      110.42     8.9135e-02    1.0631e-01    1.0807e-01    1.2737e-01
    118.69      125.71      124.07     3.1629e-02    3.0028e-02    4.3143e-02    4.0428e-02
    132.68      139.69      137.81     6.9830e-03    6.4459e-03    1.0585e-02    9.6391e-03
    146.67      153.68      151.60     1.0269e-03    1.1079e-03    1.7125e-03    1.8225e-03
    160.66      170.00      167.29     2.0538e-04    1.8025e-04    3.7887e-04    3.2719e-04
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_012_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set output "Figures/Gamma_012_Mass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_012_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y
set xlabel "Component Molecular Weight"
set ylabel "Component Mass"
set logscale y
set output "Figures/Gamma_012_LogMass_1.pdf"
plot [*:*] [*:*] $Expt using 2:6 with points title "Data", $Expt using 3:7 with lines title "Model"
unset logscale y

set output
